CElexElpas
ElexElpas
CElexElex
ElexElex

///////////////////////////////////////////////////////////////////////////////////////////
{*
#include <stdio.h>
#include "RegExpElex.h"
#include "RegExpElpas.h"
#include "ElexScript.h"
*}
///////////////////////////////////////////////////////////////////////////////////////////
{*
struct S_OutputFile {
	char*			m_pPathName;
	char*			m_pName;
};

struct S_Output {
	char*			m_pClass;
	S_OutputFile	m_sFile;
};

struct S_Prescript {
	char*			m_pInclude;
	char*			m_pDefine;
};

char* _copyString(const char* _str)
{
	int iLen = strlen(_str);
	char* ret = new char[iLen + 1];
	strncpy(ret, _str, iLen);
	ret[iLen] = 0;

	return ret;
}

void _replace(char*& _str, char* _from, char* _to)
{
	int iLen1, iLen2, iLen3, iLenNew, iCount = 0;
	int i, j;

	iLen1 = strlen(_str);
	iLen2 = strlen(_from);
	iLen3 = strlen(_to);

	for (i = 0; i < iLen1; i++) {
		if (strncmp(_str + i, _from, iLen2) == 0) {
			i += (iLen2 - 1);
			iCount ++;
		}
	}

	iLenNew = iLen1 - (iCount * iLen2) + (iCount * iLen3);
	char* pTemp = new char[iLenNew + 1];
	pTemp[iLenNew] = 0;
	j = 0;

	for (i = 0; i < iLen1; i++) {
		if (strncmp(_str + i, _from, iLen2) == 0) {
			// replace it
			strncpy(pTemp + j, _to, iLen3);
			j += iLen3;
			i += (iLen2 - 1);
		} else {
			// just add this char
			pTemp[j++] = _str[i];
		}
	}

	delete[] _str;
	_str = pTemp;
}

void _trimLeftEnter(char*& _block)
{
	int iLength = strlen(_block), iCount = 0;
	for (int i = 0; i < iLength; i++) {
		if (_block[i] == '\r' || _block[i] == '\n')
			iCount++;
		else
			break;
	}

	char* pTemp = new char[iLength - iCount + 1];
	strncpy(pTemp, _block + iCount, iLength - iCount);
	pTemp[iLength - iCount] = 0;

	delete[] _block;

	_block = pTemp;
}

void _trimRightEnter(char*& _block)
{
	int iLength = strlen(_block), iCount = 0;
	for (int i = iLength - 1; i >= 0; i--) {
		if (_block[i] == '\r' || _block[i] == '\n')
			iCount++;
		else
			break;
	}

	char* pTemp = new char[iLength - iCount + 1];
	strncpy(pTemp, _block, iLength - iCount);
	pTemp[iLength - iCount] = 0;

	delete[] _block;

	_block = pTemp;
}

SElexItem* _addRe(char* _id, char* _reblock, char* _scriptblock, char* _valueblock, bool _ignore)
{
	char *id, *re, *script, *value;
	SElexItem* pDefine;

	id = new char[strlen(_id) + 1];
	strcpy(id, _id);
	id[strlen(_id)] = 0;
	re = _copyString(_reblock);

	CRegExpElexFromString cElex(re);
	CRegExpElpasFromElex cElpas(&cElex);
	
	pDefine = new SElexItem;
	pDefine->m_pId = id;
	pDefine->m_pRe = re;
	pDefine->m_bIgnore = _ignore;
	pDefine->m_pParse = cElpas.Parse();

	if (_scriptblock) {
		script = _copyString(_scriptblock);
		_trimLeftEnter(script);
		_trimRightEnter(script);
		_replace(script, "\n", "\n\t");
		pDefine->m_pScript = script;
	}
		
	if (_valueblock) {
		value = _copyString(_valueblock);
		_trimLeftEnter(value);
		_trimRightEnter(value);
		_replace(value, "\n", "\n\t\t");
		pDefine->m_pValue = value;
	}

	return pDefine;
}

*}
///////////////////////////////////////////////////////////////////////////////////////////
<ELEXSCRIPT>
///////////////////////////////////////////////////////////////////////////////////////////
<ELEXSCRIPT> -> <DEF_OUTPUT> <DEF_PRESCRIPT> <DEF_LEXLIST>
{*
	S_Output* pOut = (S_Output*) SYM0;
	S_Prescript* pPre = (S_Prescript*) SYM1;
	list<SElexItem*>* pTemp = (list<SElexItem*>*) SYM2;
	SElexScript* pScript = new SElexScript;

	pScript->m_pClass = pOut->m_pClass;
	pScript->m_pName = pOut->m_sFile.m_pName;
	pScript->m_pPathName = pOut->m_sFile.m_pPathName;
	pScript->m_pInclude = pPre->m_pInclude;
	pScript->m_pDefine = pPre->m_pDefine;
	pScript->m_pItemList = pTemp;

	delete pOut;

	RETURN pScript;
*};

<DEF_OUTPUT> -> <DEF_ELEXNAME> <DEF_ELEXFILENAME>
{*
	S_Output* pOut = new S_Output;
	pOut->m_pClass = (char*) SYM0;
	pOut->m_sFile = *((S_OutputFile*) SYM1);
	delete (S_OutputFile*) SYM1;
	RETURN pOut;
*};

<DEF_OUTPUT> -> <DEF_ELEXFILENAME> <DEF_ELEXNAME>
{*
	S_Output* pOut = new S_Output;
	pOut->m_pClass = (char*) SYM1;
	pOut->m_sFile = *((S_OutputFile*) SYM0);
	delete (S_OutputFile*) SYM0;
	RETURN pOut;
*};

<DEF_ELEXNAME> -> ELEXNAME EQUAL ID COLON
{*
	char* pTemp = new char[strlen((char*)SYM2)+1];
	strcpy(pTemp, (char*) SYM2);
	RETURN pTemp;
*};

<DEF_ELEXFILENAME> -> ELEXFILENAME EQUAL FILE COLON
{*
	S_OutputFile* pOut = new S_OutputFile;

	pOut->m_pPathName = _copyString((char*) SYM2);
	int iPathLen = strlen(pOut->m_pPathName);

	int iSeperator = -1;
	for (int i = 0; i < iPathLen; i++) {
		// get the latest sepeator
		if (pOut->m_pPathName[i] == '\\') iSeperator = i;
	}

	pOut->m_pName = new char[iPathLen - iSeperator];
	strncpy(pOut->m_pName, pOut->m_pPathName + iSeperator + 1, iPathLen - iSeperator - 1);
	pOut->m_pName[iPathLen - iSeperator - 1] = 0;
	RETURN pOut;
*};

<DEF_INC> ->
{*
	RETURN 0;
*};
<DEF_INC> -> INCLUDE EQUAL SCRIPT_BLOCK COLON
{*
	char* script = _copyString((char*) SYM2);
	_trimLeftEnter(script);
	_trimRightEnter(script);
	RETURN script;
*};

<DEF_DEF> ->
{*
	RETURN 0;
*};

<DEF_DEF> -> DEFINE EQUAL SCRIPT_BLOCK COLON
{*
	char* script = _copyString((char*) SYM2);
	_trimLeftEnter(script);
	_trimRightEnter(script);
	RETURN script;
*};

<DEF_PRESCRIPT> -> <DEF_INC> <DEF_DEF>
{*
	S_Prescript* script = new S_Prescript;

	script->m_pInclude = (char*) SYM0;
	script->m_pDefine = (char*) SYM1;

	RETURN script;
*};

<DEF_LEXLIST> ->
{*
	RETURN new list<SElexItem*>;
*};

<DEF_LEXLIST> -> <DEF_LEX> <DEF_LEXLIST>
{*
	list<SElexItem*>* pTemp = (list<SElexItem*>*) SYM1;
	if (SYM0) 
		pTemp->insert(pTemp->begin(), (SElexItem*) SYM0);
	RETURN pTemp;
*};

<IGNORE_DEF> ->;
<IGNORE_DEF> -> IGNORE
{*
	RETURN 1;
*};

<VALUESCRIPT> ->;
<VALUESCRIPT> -> VALUE SCRIPT_BLOCK
{*
	RETURN SYM1;
*};

<LEX_SCRIPT> ->;
<LEX_SCRIPT> -> SCRIPT_BLOCK
{*
	RETURN SYM0;
*};

<DEF_LEX> -> ID <IGNORE_DEF> RE_BLOCK <LEX_SCRIPT> <VALUESCRIPT> COLON
{*
	bool bIgnore = (SYM1 ? true : false);
	RETURN _addRe((char*) SYM0, (char*) SYM2, (char*) SYM3, (char*) SYM4, bIgnore);
*};
